/*
 * QrfeRingFile.h
 *
 *  Created on: 06.06.2011
 *      Author: stefan.detter
 */

#ifndef QRFERINGFILE_H_
#define QRFERINGFILE_H_

#include <QIODevice>
#include <QMutex>

class QFile;

class QrfeRingFile : public QIODevice
{
	Q_OBJECT
public:
	QrfeRingFile( const QString & path, const QString & prefix, const QString & fileType, const uint & fileCount, const uint & maxSize, QObject * parent = 0 );
	virtual ~QrfeRingFile();

	const QString& 	path ( ) const;
	bool 			setPath ( const QString& path );
	const QString& 	prefix ( ) const;
	bool	 		setPrefix ( const QString& prefix );
	const QString& 	fileType ( ) const;
	bool	 		setFileType ( const QString& fileType );

	const uint&		fileCount ( ) const;
	void 			setFileCount ( const uint& fileCount );
	const uint&		maxSize ( ) const;
	void 			setMaxSize ( const uint& maxSize );

	const bool		append ( ) const;
	void			setAppend ( const bool append ) ;
	const bool 		risingNumber ( ) const;
	void			setRisingNumber( const bool risingNumber );


	virtual bool 	open ( OpenMode mode );
	virtual void 	close ();

    bool            flush();

public slots:
	virtual void 	writeAsciiString ( const QString & str );


protected:
	virtual qint64	writeData ( const char * data, qint64 len );
	virtual qint64 	readData ( char * data, qint64 len );

private:
	const uint  	getLastUsedFileNumber() const;

	const QString 	generateFileName ( uint fileNr ) const;
	const QString 	generateFilePathName ( uint fileNr ) const;

	const QString 	getNextFileName ( );

private:
	QMutex		m_mutex;

	QFile*		m_file;
	uint 		m_currentFileNr;

	QString 	m_path;
	QString 	m_prefix;
	QString 	m_fileType;

	bool		m_append;
	bool 		m_risingNumber;

	uint 		m_fileCount;
	uint 		m_maxSize;
};

#endif /* QRFERINGFILE_H_ */
